package gov.va.med.mhv.sm.web.actions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.sm.model.Administrator;
import gov.va.med.mhv.sm.model.MhvAuthenticationSubject;
import gov.va.med.mhv.sm.model.decorator.MhvAuthenticationSubjectDecorator;
import gov.va.med.mhv.sm.service.AuthenticationService;
import gov.va.med.mhv.sm.util.MhvIntegrationUtils;

import com.opensymphony.xwork2.Preparable;

public class AuthenticateTest extends BaseSMAdminAction implements Preparable {

	private static final long serialVersionUID = 1527699243676622366L;
	
	private static final Log LOG = LogFactory.getLog(AuthenticateTest.class); 

	private static final String LOGINFAILED_RESULT = "LOGINFAILED";

	private AuthenticationService authenticationService = null;
	private MhvIntegrationUtils utils = null;
	
	private int userid = 0; 
	
	public void prepare() throws Exception {
		super.prepare();
		authenticationService = (AuthenticationService) getBean(
			"authenticationService");
		utils = (MhvIntegrationUtils) getBean("mhvIntegrationUtils");
	}

	
	public void setUserid(String userid) {
		try { 
			this.userid = Integer.parseInt(userid);
		} catch (NumberFormatException e) {
			LOG.error("Failed to get admin id from [" + userid + "]", e);
			this.userid = 0;
		}
	}

	/**
	 * Login as an administrator with a couple of facilities to admin only
	 * 
	 * @return
	 */
	public String loginAdmin() {
		if (utils.getSettings().isProductionMode()) {
			addActionError("Unable to validated your credentials");
			return LOGINFAILED_RESULT;
		}
		MhvAuthenticationSubject subject = createSubject(); 
		if (subject == null) {
			LOG.error("Unknown administrator userid=" + userid);
			return LOGINFAILED_RESULT;
		}
		ServiceResponse<Administrator> response = authenticationService.
			authenticateAdministrator(subject);
		if (hasError(response)) {
			LOG.error(getErrorText(response));
			return LOGINFAILED_RESULT;
		}
		setSessionAttribute(CURRENT_USER, response.getPayload());
		if (getSessionAttribute(CURRENT_USER) == null) {
			LOG.error("Administrator not found");
			return LOGINFAILED_RESULT;
		}
		
		return SUCCESS;
	}
	
	private MhvAuthenticationSubject createSubject() {
		switch (userid) {
		
			case 1: return createSubject("jkr", "JK", "Rowlings", 
				new String[] {"991","994"}, new String[] {}, false);

			case 2: return createSubject("vhaiswmanivr", "SM", "Visn", 
					new String[] {"989","979"}, new String[] {"VISN 19"}, false);
			
			case 3: return createSubject("vhaiswgrahak", "SM", "National", 
				new String[] { }, 
				new String[] { }, true);
			
			case 5: return createSubject("jkr", "JK", "Rowlings", 
					new String[] {"989","979"}, new String[] {}, false);
				
			default: {
				LOG.error("Cannot create authentication subject for userid=" + 
					userid);
				return null;
			}
		} 
	}

	private MhvAuthenticationSubject createSubject(String userName, 
		String firstName, String lastName, String[] facilities, String[] visns, 
		Boolean isNational) 
	{
		MhvAuthenticationSubject subject = new MhvAuthenticationSubject();
		Long timestamp = System.currentTimeMillis() + 5000;
		subject.setTimestamp(timestamp);
		subject.setUserName(userName);
		subject.setFirstName(firstName);
		subject.setLastName(lastName);
		subject.setFacilities(facilities);
		subject.setVisns(visns);
		subject.setNational(isNational);
		subject.setSource(utils.getSettings().getAdministratorSource());
		subject.setAuthenticated(true);
		subject.setChecksum(new MhvAuthenticationSubjectDecorator(subject, 
			utils).createChecksum());
		return subject;
	}

}
